# NPLL: Neural Probabilistic Logic Learning for Knowledge Graph Reasoning
**Introduction**

This is the PyTorch implementation of the NPLL model for knowledge graph reasoning. 

**Requirements**
- python 3.7
- pytorch 1.1
- scikit-learn
- networkx
- tqdm
- numpy

**Implemented features**

Evaluation Metrics:

 - [x] MRR, MR, HITS@1, HITS@3, HITS@10 (filtered)

**Usage**

Knowledge Graph Data:
 - *entities.txt*: entities to unique ids
 - *relations.txt*: relations to unique ids
 - *XX_rules_XX.txt*: logic rules of dataset
 - *facts.txt,train.txt*: the KGR model is trained to fit  data sets
 - *valid.txt*: create a blank file if no validation data is available
 - *test.txt*: the KGR model is evaluated on this data set

**Train**
*NPLL-basic*
This command train a NPLL-basic model on FB15k-237 dataset with GPU 0. Form size 0% to 100%
```
python -m main.train -data_root data/fb15k-237_0 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 0 -num_hops 1 -embedding_size 256 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_0 -device cuda
python -m main.train -data_root data/fb15k-237_0.05 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 0 -num_hops 1 -embedding_size 256 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_0.05 -device cuda
python -m main.train -data_root data/fb15k-237_0.1 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 0 -num_hops 1 -embedding_size 256 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_0.1 -device cuda
python -m main.train -data_root data/fb15k-237_0.2 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 0 -num_hops 1 -embedding_size 256 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_0.2 -device cuda
python -m main.train -data_root data/fb15k-237 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 0 -num_hops 1 -embedding_size 256 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237 -device cuda
```
This command train a NPLL-basic model on WN18RR dataset with GPU 0.
```
python -m main.train -data_root data/WN18RR -rule_filename WN18RR_rules_0.99.txt -slice_dim 16 -batchsize 8 -use_gcn 0 -num_hops 1 -embedding_size 256  -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name wn18rr -device cuda
```
This command train a NPLL-basic model on codex-l yago37 YAGO3-10 dataset with GPU 0.
```
python -m main.train -data_root data/codex-l -rule_filename codex-l_rules_0.61.txt -slice_dim 16 -batchsize 32 -use_gcn 0 -num_hops 1 -embedding_size 256  -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name codex-l -device cuda
python -m main.train -data_root data/YAGO3-10 -rule_filename rule/YAGO3-10_rules_0.341.txt -slice_dim 16 -batchsize 64 -use_gcn 0 -num_hops 1 -embedding_size 256  -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name YAGO3-10 -device cuda
python -m main.train -data_root data/yago37 -rule_filename rule/yago37_rules_0.9.txt -slice_dim 16 -batchsize 64 -use_gcn 0 -num_hops 1 -embedding_size 256  -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name yago37 -device cuda
```
This command train a NPLL-basic model on Kinship dataset with GPU 0.
```
python -m main.train -data_root data/kinship -rule_filename kinship_rules_0.99.txt -slice_dim 16 -batchsize 8 -use_gcn 0 -num_hops 1 -embedding_size 512  -patience 20 -lr_decay_patience 100  -exp_folder exp -exp_name kinship -device cuda
```
python -m main.train -data_root data/kinship_0.12 -rule_filename kinship_rules_0.99.txt -slice_dim 16 -batchsize 8 -use_gcn 0 -num_hops 1 -embedding_size 512  -patience 20 -lr_decay_patience 100  -exp_folder exp -exp_name kinship_0.12 -device cuda
python -m main.train -data_root data/kinship_0.1 -rule_filename kinship_rules_0.99.txt -slice_dim 16 -batchsize 8 -use_gcn 0 -num_hops 1 -embedding_size 512  -patience 20 -lr_decay_patience 100  -exp_folder exp -exp_name kinship_0.12 -device cuda

This command train a NPLL-basic model on UMLS dataset with GPU 0.
```
python -m main.train -data_root data/umls -rule_filename umls_rules_0.txt -slice_dim 16 -batchsize 8 -use_gcn 0 -num_hops 1 -embedding_size 128 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name umls -device cuda

```
*NPLL-GNN*
This command train a NPLL-GNN model on FB15k-237 dataset with GPU 0. Form size 0% to 100%
```
python -m main.train -data_root data/fb15k-237_0 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_GNN_0 -device cuda
python -m main.train -data_root data/fb15k-237_0.05 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_GNN_0.05 -device cuda
python -m main.train -data_root data/fb15k-237_0.1 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_GNN_0.1 -device cuda
python -m main.train -data_root data/fb15k-237_0.2 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_GNN_0.2 -device cuda
python -m main.train -data_root data/fb15k-237 -rule_filename fb15k-237_rules_0.87.txt -slice_dim 16 -batchsize 16 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name fb15k-237_GNN -device cuda
```
This command train a NPLL-GNN model on WN18RR dataset with GPU 0.




```
python -m main.train -data_root data/WN18RR -rule_filename WN18RR_rules_0.99.txt -slice_dim 16 -batchsize 8 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name wn18rr_GNN -device cuda
```
This command train a NPLL-GNN model on Kinship dataset with GPU 0.
```[YAGO3-10](data%2FYAGO3-10)
python -m main.train -data_root data/kinship -rule_filename kinship_rules_0.99.txt -slice_dim 16 -batchsize 8 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100  -exp_folder exp -exp_name kinship_GNN -device cuda
```
This command train a NPLL-GNN model on WN18RR dataset with GPU 0.
```
python -m main.train -data_root data/umls -rule_filename umls_rules_0.txt -slice_dim 16 -batchsize 8 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100  -exp_folder exp -exp_name umls_GNN -device cuda
```
This command train a NPLL-GNN model on codex-l yago37 YAGO3-10 dataset with GPU 0.
```
python -m main.train -data_root data/codex-l -rule_filename codex-l_rules_0.61.txt -slice_dim 16 -batchsize 16 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name codex-l_GNN -device cuda
python -m main.train -data_root data/yago37 -rule_filename rule/yago37_rules_1.0.txt -slice_dim 16 -batchsize 64 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name yago37_GNN -device cuda
python -m main.train -data_root data/YAGO3-10 -rule_filename rule/YAGO3-10_rules_0.341.txt -slice_dim 16 -batchsize 64 -use_gcn 1 -num_hops 1 -embedding_size 128 -gcn_free_size 127 -patience 20 -lr_decay_patience 100 -exp_folder exp -exp_name YAGO3-10_GNN -device cuda
```


This code partially is borrowed from [ExpressGNN](https://github.com/expressGNN/ExpressGNN)